/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.runtime.dialog;

import filenet.vw.toolkit.runtime.resources.VWResource;
import filenet.vw.toolkit.runtime.table.VWTrackerStatus;
import filenet.vw.toolkit.runtime.table.VWTrackerSummaryCellRenderer;
import filenet.vw.toolkit.utils.VWStringUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public final class VWStatusDetailsDialog
extends JDialog
implements ActionListener {
    private JLabel m_mapName = new JLabel();
    private JLabel m_stepName = new JLabel();
    private JLabel m_occurrence = new JLabel();
    private JLabel m_participantName = new JLabel();
    private JLabel m_operationName = new JLabel(VWResource.s_na);
    private JLabel m_received = new JLabel();
    private JLabel m_status = new JLabel();
    private JLabel m_response = new JLabel();
    private JTextArea m_comments = new JTextArea();
    private JButton m_closeButton = new JButton(VWResource.s_close);

    public VWStatusDetailsDialog(Frame parent) {
        super(parent, false);
        this.setupLayout();
    }

    protected void setupLayout() {
        Container contentPane = this.getContentPane();
        this.setResizable(true);
        Dimension dim = VWStringUtils.stringToDimension(VWResource.s_statusDetailsDialogDim);
        if (dim == null) {
            dim = new Dimension(330, 360);
        }
        this.setSize(dim.width, dim.height);
        this.setVisible(false);
        this.setTitle(VWResource.s_statusDetails);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout(10, 10));
        JPanel statusPanel = new JPanel();
        statusPanel.setLayout(new BorderLayout(10, 10));
        JPanel labelPanel = new JPanel();
        labelPanel.setLayout(new BoxLayout(labelPanel, 3));
        labelPanel.add(new JLabel(VWResource.s_label.toString(VWResource.s_map)));
        labelPanel.add(new JLabel(VWResource.s_label.toString(VWResource.s_step)));
        labelPanel.add(new JLabel(VWResource.s_label.toString(VWResource.s_occurrence)));
        labelPanel.add(new JLabel(VWResource.s_label.toString(VWResource.s_participant)));
        labelPanel.add(new JLabel(VWResource.s_label.toString(VWResource.s_operation)));
        labelPanel.add(new JLabel(VWResource.s_label.toString(VWResource.s_received)));
        labelPanel.add(new JLabel(VWResource.s_label.toString(VWResource.s_status)));
        labelPanel.add(new JLabel(VWResource.s_label.toString(VWResource.s_response)));
        JPanel statusInfoPanel = new JPanel();
        statusInfoPanel.setLayout(new BoxLayout(statusInfoPanel, 3));
        statusInfoPanel.add(this.m_mapName);
        statusInfoPanel.add(this.m_stepName);
        statusInfoPanel.add(this.m_occurrence);
        statusInfoPanel.add(this.m_participantName);
        statusInfoPanel.add(this.m_operationName);
        statusInfoPanel.add(this.m_received);
        statusInfoPanel.add(this.m_status);
        statusInfoPanel.add(this.m_response);
        statusPanel.add((Component)labelPanel, "Before");
        statusPanel.add((Component)statusInfoPanel, "Center");
        JPanel commentsPanel = new JPanel(new BorderLayout());
        commentsPanel.add((Component)new JLabel(VWResource.s_label.toString(VWResource.s_comments)), "First");
        this.m_comments.setLineWrap(true);
        this.m_comments.setWrapStyleWord(true);
        this.m_comments.setEditable(false);
        this.m_comments.setBorder(BorderFactory.createEtchedBorder());
        commentsPanel.add((Component)new JScrollPane(this.m_comments), "Center");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout());
        buttonPanel.add(this.m_closeButton);
        mainPanel.add((Component)commentsPanel, "Center");
        mainPanel.add((Component)statusPanel, "First");
        mainPanel.add((Component)buttonPanel, "Last");
        mainPanel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)mainPanel, "Center");
        Frame parent = (Frame)this.getParent();
        if (parent != null && parent instanceof JFrame) {
            this.setLocationRelativeTo(parent);
        } else {
            Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
            this.setLocation((screenDim.width - this.getWidth()) / 2, (screenDim.height - this.getHeight()) / 2);
        }
        this.m_closeButton.addActionListener(this);
        ComponentOrientation compOrientation = ComponentOrientation.getOrientation(Locale.getDefault());
        this.applyComponentOrientation(compOrientation);
    }

    public void addNotify() {
        super.addNotify();
    }

    public void actionPerformed(ActionEvent e) {
        this.setVisible(false);
    }

    public void setMapName(Object value) {
        if (value != null && value instanceof String) {
            this.m_mapName.setText((String)value);
        } else {
            this.m_mapName.setText(" ");
        }
    }

    public void setStepName(Object value) {
        String text = null;
        Icon icon = null;
        if (value != null) {
            if (value instanceof String) {
                text = (String)value;
            } else if (value instanceof JLabel) {
                text = ((JLabel)value).getText();
                icon = ((JLabel)value).getIcon();
            }
        }
        this.m_stepName.setText(text);
        this.m_stepName.setIcon(icon);
    }

    public void setOccurrence(Object value) {
        if (value != null && value instanceof Integer) {
            this.m_occurrence.setText(((Integer)value).toString());
        } else {
            this.m_occurrence.setText(" ");
        }
    }

    public void setParticipant(Object value) {
        if (value != null || value instanceof JLabel) {
            this.m_participantName.setText(((JLabel)value).getText());
            this.m_participantName.setIcon(((JLabel)value).getIcon());
        } else {
            this.m_participantName.setText(VWResource.s_na);
            this.m_participantName.setIcon(null);
        }
    }

    public void setOperation(Object value) {
        if (value != null || value instanceof JLabel) {
            this.m_operationName.setText(((JLabel)value).getText());
            this.m_operationName.setIcon(((JLabel)value).getIcon());
        } else {
            this.m_operationName.setText(VWResource.s_na);
            this.m_operationName.setIcon(null);
        }
    }

    public void setReceived(Object value) {
        if (value != null && (value instanceof Calendar || value instanceof Date)) {
            this.m_received.setText(VWTrackerSummaryCellRenderer.toString(value));
        } else {
            this.m_received.setText(" ");
        }
    }

    public void setStatus(Object value) {
        if (value != null && value instanceof VWTrackerStatus) {
            this.m_status.setText(VWTrackerSummaryCellRenderer.toString(value));
            this.m_status.setIcon(VWTrackerSummaryCellRenderer.getIcon(value));
        } else {
            this.m_status.setText(" ");
            this.m_status.setIcon(null);
        }
    }

    public void setResponse(Object value) {
        if (value != null && value instanceof String) {
            this.m_response.setText((String)value);
        } else {
            this.m_response.setText(VWResource.s_none);
        }
    }

    public void setComments(Object value) {
        if (value != null && value instanceof String) {
            this.m_comments.setText((String)value);
        } else {
            this.m_comments.setText(" ");
        }
    }

    public void clearAll() {
        this.m_mapName.setText(null);
        this.m_mapName.setText(null);
        this.m_stepName.setText(null);
        this.m_stepName.setIcon(null);
        this.m_occurrence.setText(null);
        this.m_occurrence.setIcon(null);
        this.m_participantName.setText(null);
        this.m_participantName.setIcon(null);
        this.m_received.setText(null);
        this.m_received.setIcon(null);
        this.m_status.setText(null);
        this.m_status.setIcon(null);
        this.m_response.setText(null);
        this.m_response.setIcon(null);
        this.m_comments.setText(null);
    }

    public void removeReferences() {
        this.m_mapName = null;
        this.m_stepName = null;
        this.m_occurrence = null;
        this.m_participantName = null;
        this.m_received = null;
        this.m_status = null;
        this.m_response = null;
        this.m_comments = null;
        if (this.m_closeButton != null) {
            this.m_closeButton.removeActionListener(this);
            this.m_closeButton = null;
        }
        this.dispose();
    }
}

